#ifndef CRFEPURFREQUENCYSWEEPMEASUREMENT_H
#define CRFEPURFREQUENCYSWEEPMEASUREMENT_H

#include "../../ui/TabWidget.h"
#include "../../ui/ConfigDialog.h"
#include <ui_CRfePurFrequencySweepMeasurement.h>

class QStandardItemModel;

class QwtPlot;
class QwtPlotCurve;
class QwtPlotPicker;

class QrfeRfePurReader;

class CRfePurFrequencySweepMeasurement : public ReaderTabWidget, ConfigDialog
{
    Q_OBJECT

public:
    CRfePurFrequencySweepMeasurement(QTextEdit* infoEdit, QWidget* parent);
    ~CRfePurFrequencySweepMeasurement();

	virtual bool init(QrfeReaderInterface* reader);
	virtual void deinit();
	virtual void activated();

	virtual bool hasExecutionCount();

private slots:
	void startButtonClicked();
	void runFrequencySweep();
	void exportSweepResults();

	void setAttenuationLabel ( int value );
	void showMaxHold ( bool on );
	void showLoopUsed ( bool on );

	void clearAllSweepValues ( );
	void clearDynamicSweepValues ( );

	void sweepMethodChanged( );
	void sweepMeasurementValuesChanged ( );

private:
	void measureRssiSweep(ulong freq, ushort time, double &dBm, double &ival, double &qval);
	void measureRfpSweep(ulong freq, ushort time, double &dBm, double &ival, double &qval);

    void loadValuesFromCache();
    void saveValuesToCache();

	void reloadLicenseData();

private:
    QrfeRfePurReader* 		m_reader;
    short 					m_sensitivity;

	QStandardItemModel*		m_freqSweepValueModel;
	QwtPlot*				m_freqSweepPlot;
	QwtPlotCurve*			m_freqSweepdBmCurve;
	QwtPlotCurve*			m_freqSweepdBmMaxCurve;
	QwtPlotCurve*			m_freqSweepRawICurve;
	QwtPlotCurve*			m_freqSweepRawQCurve;
	QwtPlotPicker* 			m_picker;

	QVector<double> 		m_maxHoldVals;
	QVector<double> 		m_maxHoldFreqs;

	bool					m_measurementActive;
	bool 					m_continueMeasurement;

    Ui::CRfePurFrequencySweepMeasurementClass ui;
};

#endif // CRFEPURFREQUENCYSWEEPMEASUREMENT_H
